/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.shynieke.statues.recipe.StatuesRecipes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class HardcoreRecipe
extends ShapedRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;

    public HardcoreRecipe(ResourceLocation location, String group, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(location, group, width, height, recipeItems, result);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)StatuesRecipes.HARDCORE_SHAPED_SERIALIZER.get();
    }

    public boolean m_5818_(CraftingContainer container, Level level) {
        return super.m_5818_(container, level) && level != null && level.m_6106_().m_5466_();
    }

    public ItemStack m_8043_() {
        ItemStack resultStack = super.m_8043_();
        CompoundTag display = resultStack.m_41698_("display");
        if (!display.m_128441_("lore")) {
            ListTag nbtTagList = new ListTag();
            nbtTagList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TextComponent("Only craftable in Hardcore Mode").m_130940_(ChatFormatting.DARK_PURPLE))));
            display.m_128365_("Lore", (Tag)nbtTagList);
        }
        return resultStack;
    }

    public ItemStack m_5874_(CraftingContainer container) {
        return this.m_8043_().m_41777_();
    }

    static NonNullList<Ingredient> dissolvePattern(String[] p_44203_, Map<String, Ingredient> p_44204_, int p_44205_, int p_44206_) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(p_44205_ * p_44206_), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(p_44204_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_44203_.length; ++i) {
            for (int j = 0; j < p_44203_[i].length(); ++j) {
                String s = p_44203_[i].substring(j, j + 1);
                Ingredient ingredient = p_44204_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_44205_ * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... p_44187_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_44187_.length; ++i1) {
            String s = p_44187_[i1];
            i = Math.min(i, HardcoreRecipe.firstNonSpace(s));
            int j1 = HardcoreRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_44187_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_44187_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_44187_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String p_44185_) {
        int i;
        for (i = 0; i < p_44185_.length() && p_44185_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String p_44201_) {
        int i;
        for (i = p_44201_.length() - 1; i >= 0 && p_44201_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static Map<String, Ingredient> keyFromJson(JsonObject jsonObject) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    static String[] patternFromJson(JsonArray array) {
        String[] astring = new String[array.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)array.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<HardcoreRecipe> {
        public HardcoreRecipe fromJson(ResourceLocation location, JsonObject jsonObject) {
            String s = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            Map<String, Ingredient> map = HardcoreRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"key"));
            String[] pattern = HardcoreRecipe.shrink(HardcoreRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"pattern")));
            int i = pattern[0].length();
            int j = pattern.length;
            NonNullList<Ingredient> nonnulllist = HardcoreRecipe.dissolvePattern(pattern, map, i, j);
            ItemStack itemstack = HardcoreRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            return new HardcoreRecipe(location, s, i, j, nonnulllist, itemstack);
        }

        public HardcoreRecipe fromNetwork(ResourceLocation location, FriendlyByteBuf byteBuf) {
            int i = byteBuf.m_130242_();
            int j = byteBuf.m_130242_();
            String s = byteBuf.m_130277_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)byteBuf));
            }
            ItemStack itemstack = byteBuf.m_130267_();
            return new HardcoreRecipe(location, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(FriendlyByteBuf byteBuf, HardcoreRecipe recipe) {
            byteBuf.m_130130_(recipe.m_44220_());
            byteBuf.m_130130_(recipe.m_44221_());
            byteBuf.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(byteBuf);
            }
            byteBuf.m_130055_(recipe.m_8043_());
        }
    }
}

